/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

#include "chunk.h"
using namespace std;

chunk::chunk( void )
{
	start_index = 0;
	stop_index = 0;
	chunk_type = 26;
	input_type = true;
	to = false;
}

chunk::chunk( bool b )
{
	start_index = 0;
	stop_index = 0;
	chunk_type = 26;
	input_type = b;
	to = false;
}

chunk::chunk( const chunk & c )
{
	start_index = c.start_index;
	stop_index = c.stop_index;
	chunk_type = c.chunk_type;
	input_type = c.input_type;
	to = c.to;
}

chunk::~chunk( void )
{
	/* do nothing */;
}

void chunk::add_index( int idx, int chtype )
{
	if( ! input_type )
	{
		// Normal, everyday, garden variety input chunk.
		// This whole block is FUBAR. It works, but I
		// don't claim to comprehend why.
		
		if( chtype == 99 )
		{
			stop_index = idx;
			to = true;
		}
		else
		{
			if( ! to )
			{
				stop_index = idx;
			}
			start_index = idx;
			chunk_type = chtype;
		}
	}
	else
	{
		// Nasty, antisocial output type chunk.
		// If you only knew how many twinkies went
		// into the thought process for this.
		
		if( chtype == 99 )
		{
			chunk_data.top().chunk_end = idx;
		}
		else
		{
			chunk_data.push( chunk_record( chtype, idx, idx ) );
		}
	}
}

const chunk & chunk::operator = ( const chunk & c )
{
	start_index = c.start_index;
	stop_index = c.stop_index;
	chunk_type = c.chunk_type;
	input_type = c.input_type;
	return * this;
}

string chunk::crunch( const string & s, const string & t )
{
	int c_start ( 1 );
	int c_stop ( 1 );
	string current_bite;
	if( ! input_type )
	{
		// Normal procedure for input chunks.
		return cxl_get_chunk( s, name_from_chunk_id( chunk_type ), start_index, stop_index );
	}
	else
	{
		// New procedure for output chunks.
		current_bite = s;
		while( ( int ) chunk_data.size() > 0 )
		{
			c_stop = c_start + cxl_chunk_end( current_bite, name_from_chunk_id( chunk_data.top().chunk_type ), chunk_data.top().chunk_start, chunk_data.top().chunk_end );
			c_start += cxl_chunk_start( current_bite, name_from_chunk_id( chunk_data.top().chunk_type ), chunk_data.top().chunk_start, chunk_data.top().chunk_end );
			chunk_data.pop();
			current_bite = cxl_get_chunk( s, "char", c_start, c_stop );
		}
		current_bite = cxl_put_into_chunk( s, "char", c_start, c_stop, t );
		return current_bite;
	}
}

string chunk::name_from_chunk_id( int i )
{
	switch( i )
	{
		case 26:
			return "char";
			break;
		case 27:
			return "word";
			break;
		case 28:
			return "line";
			break;
		case 29:
			return "item";
			break;
		case 30:
			return "sent";
			break;
		case 31:
			return "para";
			break;
		case 32:
			return "elem";
			break;
		default:
			return "char";
			break;
	}
}
